/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class HorridShadowspinnerEffect
extends OneShotEffect {
    HorridShadowspinnerEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw cards equal to its power. If you do, discard that many cards";
    }

    private HorridShadowspinnerEffect(HorridShadowspinnerEffect effect) {
        super((OneShotEffect)effect);
    }

    public HorridShadowspinnerEffect copy() {
        return new HorridShadowspinnerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player == null || permanent == null) {
            return false;
        }
        int power = Math.max(permanent.getPower().getValue(), 0);
        player.drawCards(power, source, game);
        player.discard(power, false, false, source, game);
        return true;
    }
}

