/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class HotheadedGiantWatcher
extends Watcher {
    private final Map<UUID, List<MageObjectReference>> spellMap = new HashMap<UUID, List<MageObjectReference>>();
    private static final List<MageObjectReference> emptyList = Collections.unmodifiableList(new ArrayList());

    HotheadedGiantWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getSourceId());
        if (spell != null && spell.getColor(game).isRed()) {
            this.spellMap.computeIfAbsent(event.getPlayerId(), x -> new ArrayList()).add(new MageObjectReference(event.getSourceId(), game));
        }
    }

    public void reset() {
        super.reset();
        this.spellMap.clear();
    }

    static boolean checkSpell(Game game, Ability source) {
        return ((HotheadedGiantWatcher)game.getState().getWatcher(HotheadedGiantWatcher.class)).spellMap.getOrDefault(source.getControllerId(), emptyList).stream().noneMatch(mor -> !mor.refersTo(source, game));
    }
}

