/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AttachedToMatchesFilterCondition;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.UntapAttachedEffect;
import mage.abilities.effects.common.continuous.BoostEnchantedEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FlashAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class HowlOfTheHunt
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("enchanted creature is a Wolf or Werewolf");
    private static final Condition condition;

    public HowlOfTheHunt(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{G}");
        this.subtype.add((Object)SubType.AURA);
        this.addAbility((Ability)FlashAbility.getInstance());
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        this.addAbility((Ability)new EntersBattlefieldTriggeredAbility((Effect)new UntapAttachedEffect().setText("untap that creature")).withInterveningIf(condition));
        SimpleStaticAbility ability = new SimpleStaticAbility((Effect)new BoostEnchantedEffect(2, 2));
        ability.addEffect((Effect)new GainAbilityAttachedEffect((Ability)VigilanceAbility.getInstance(), AttachmentType.AURA).setText("and has vigilance"));
        this.addAbility((Ability)ability);
    }

    private HowlOfTheHunt(HowlOfTheHunt card) {
        super((CardImpl)card);
    }

    public HowlOfTheHunt copy() {
        return new HowlOfTheHunt(this);
    }

    static {
        filter.add(Predicates.or((Predicate)SubType.WOLF.getPredicate(), (Predicate)SubType.WEREWOLF.getPredicate()));
        condition = new AttachedToMatchesFilterCondition(filter);
    }
}

