/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class HowlpackPiperEffect
extends OneShotEffect {
    HowlpackPiperEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you may put a creature card from your hand onto the battlefield. If it's a Wolf or Werewolf, untap {this}";
    }

    private HowlpackPiperEffect(HowlpackPiperEffect effect) {
        super((OneShotEffect)effect);
    }

    public HowlpackPiperEffect copy() {
        return new HowlpackPiperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().count((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game) < 1) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE);
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        if (card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || sourcePermanent == null) {
            return true;
        }
        if (permanent.hasSubtype(SubType.WOLF, game) || permanent.hasSubtype(SubType.WEREWOLF, game)) {
            sourcePermanent.untap(game);
        }
        return true;
    }
}

