/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.CantBlockTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class HuatliWarriorPoetDamageEffect
extends OneShotEffect {
    HuatliWarriorPoetDamageEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage divided as you choose among any number of target creatures. Creatures dealt damage this way can't block this turn";
    }

    private HuatliWarriorPoetDamageEffect(HuatliWarriorPoetDamageEffect effect) {
        super((OneShotEffect)effect);
    }

    public HuatliWarriorPoetDamageEffect copy() {
        return new HuatliWarriorPoetDamageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (source.getTargets().isEmpty()) {
            return true;
        }
        Target multiTarget = (Target)source.getTargets().get(0);
        for (UUID target : multiTarget.getTargets()) {
            Permanent permanent = game.getPermanent(target);
            if (permanent == null || permanent.damage(multiTarget.getTargetAmount(target), source.getSourceId(), source, game, false, true) <= 0) continue;
            CantBlockTargetEffect effect = new CantBlockTargetEffect(Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

