/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.SpliceAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.target.common.TargetControlledPermanent;
import mage.target.common.TargetCreaturePermanent;

public final class HundredTalonStrike
extends CardImpl {
    private static final FilterControlledPermanent filter = new FilterControlledCreaturePermanent("untapped white creature you control");

    public HundredTalonStrike(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{W}");
        this.subtype.add((Object)SubType.ARCANE);
        this.getSpellAbility().addEffect((Effect)new BoostTargetEffect(1, 0).setText("Target creature gets +1/+0"));
        this.getSpellAbility().addEffect((Effect)new GainAbilityTargetEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn).setText("and gains first strike until end of turn"));
        this.getSpellAbility().addTarget(new TargetCreaturePermanent().withChooseHint("+1/+0 and first strike"));
        this.addAbility((Ability)new SpliceAbility(SpliceAbility.ARCANE, (Cost)new TapTargetCost(new TargetControlledPermanent(filter))));
    }

    private HundredTalonStrike(HundredTalonStrike card) {
        super((CardImpl)card);
    }

    public HundredTalonStrike copy() {
        return new HundredTalonStrike(this);
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
        filter.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
    }
}

