/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.costs.common.RemoveCounterCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.CounterAnyPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledPermanent;

class HungryHungryHeiferEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("a permanent you control with a counter on it");

    public HungryHungryHeiferEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "you may remove a counter from a permanent you control. If you don't, sacrifice {this}";
    }

    private HungryHungryHeiferEffect(HungryHungryHeiferEffect effect) {
        super((OneShotEffect)effect);
    }

    public HungryHungryHeiferEffect copy() {
        return new HungryHungryHeiferEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = source.getSourcePermanentIfItStillExists(game);
        if (sourceObject != null && controller != null) {
            TargetControlledPermanent target;
            RemoveCounterCost cost;
            if (controller.chooseUse(this.outcome, "Remove a counter from a permanent you control?", source, game) && (cost = new RemoveCounterCost((Target)(target = new TargetControlledPermanent(1, 1, filter, true)))).pay(null, game, source, controller.getId(), true)) {
                return true;
            }
            sourceObject.sacrifice(source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)CounterAnyPredicate.instance);
    }
}

