/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.h.HuntersInsightTriggeredAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HuntersInsightEffect
extends OneShotEffect {
    HuntersInsightEffect() {
        super(Outcome.Benefit);
        this.staticText = "Choose target creature you control. Whenever that creature deals combat damage to a player or planeswalker this turn, draw that many cards.";
    }

    private HuntersInsightEffect(HuntersInsightEffect effect) {
        super((OneShotEffect)effect);
    }

    public HuntersInsightEffect copy() {
        return new HuntersInsightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new HuntersInsightTriggeredAbility(new MageObjectReference((MageObject)permanent, game)), source);
        return true;
    }
}

