/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class HydrasGrowthDoubleEffect
extends OneShotEffect {
    HydrasGrowthDoubleEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "double the number of +1/+1 counters on enchanted creature";
    }

    private HydrasGrowthDoubleEffect(HydrasGrowthDoubleEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent attachedTo;
        Permanent permanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (permanent != null && permanent.getAttachedTo() != null && (attachedTo = game.getPermanent(permanent.getAttachedTo())) != null) {
            int amount = attachedTo.getCounters(game).getCount(CounterType.P1P1);
            if (amount > 0) {
                attachedTo.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }

    public HydrasGrowthDoubleEffect copy() {
        return new HydrasGrowthDoubleEffect(this);
    }
}

