/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.common.TargetCardInHand;

class HypergenesisEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("an artifact, creature, enchantment, or land card");

    HypergenesisEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "Starting with you, each player may put an artifact, creature, enchantment, or land card from their hand onto the battlefield. Repeat this process until no one puts a card onto the battlefield.";
    }

    private HypergenesisEffect(HypergenesisEffect effect) {
        super((OneShotEffect)effect);
    }

    public HypergenesisEffect copy() {
        return new HypergenesisEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            PlayerList playerList = game.getState().getPlayerList().copy();
            while (!((UUID)playerList.get()).equals(source.getControllerId()) && controller.canRespond()) {
                playerList.getNext();
            }
            Player currentPlayer = game.getPlayer((UUID)playerList.get());
            UUID firstInactivePlayer = null;
            TargetCardInHand target = new TargetCardInHand(filter);
            while (controller.canRespond()) {
                if (currentPlayer != null && currentPlayer.canRespond() && game.getState().getPlayersInRange(controller.getId(), game).contains((Object)currentPlayer.getId())) {
                    Card card;
                    if (firstInactivePlayer == null) {
                        firstInactivePlayer = currentPlayer.getId();
                    }
                    target.clearChosen();
                    if (target.canChoose(currentPlayer.getId(), source, game) && currentPlayer.chooseUse(this.outcome, "Put card from your hand to play?", source, game) && target.chooseTarget(this.outcome, currentPlayer.getId(), source, game) && (card = game.getCard(target.getFirstTarget())) != null) {
                        currentPlayer.moveCards(card, Zone.BATTLEFIELD, source, game);
                        firstInactivePlayer = null;
                    }
                }
                playerList.getNext();
                currentPlayer = game.getPlayer((UUID)playerList.get());
                if (!currentPlayer.getId().equals(firstInactivePlayer)) continue;
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.ARTIFACT.getPredicate(), CardType.CREATURE.getPredicate(), CardType.ENCHANTMENT.getPredicate(), CardType.LAND.getPredicate()}));
    }
}

