/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.h;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class HypnoxExileEffect
extends OneShotEffect {
    HypnoxExileEffect() {
        super(Outcome.Exile);
        this.staticText = "exile all cards from target opponent's hand";
    }

    private HypnoxExileEffect(HypnoxExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        return controller.moveCardsToExile(player.getHand().getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
    }

    public HypnoxExileEffect copy() {
        return new HypnoxExileEffect(this);
    }
}

