/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class CanAttackAsThoughItHadHasteEnchantedEffect
extends AsThoughEffectImpl {
    CanAttackAsThoughItHadHasteEnchantedEffect(Duration duration) {
        super(AsThoughEffectType.ATTACK_AS_HASTE, duration, Outcome.Benefit);
        this.staticText = "Enchanted creature can attack as though it had haste";
    }

    private CanAttackAsThoughItHadHasteEnchantedEffect(CanAttackAsThoughItHadHasteEnchantedEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public CanAttackAsThoughItHadHasteEnchantedEffect copy() {
        return new CanAttackAsThoughItHadHasteEnchantedEffect(this);
    }

    public boolean applies(UUID objectId, Ability source, UUID affectedControllerId, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        return enchantment != null && enchantment.isAttachedTo(objectId);
    }
}

