/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceBasicLandType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ChooseTwoBasicLandTypesEffect
extends OneShotEffect {
    String choiceOne;
    String choiceTwo;

    public ChooseTwoBasicLandTypesEffect(Outcome outcome) {
        super(outcome);
        this.staticText = "choose two basic land types";
    }

    private ChooseTwoBasicLandTypesEffect(ChooseTwoBasicLandTypesEffect effect) {
        super((OneShotEffect)effect);
    }

    public ChooseTwoBasicLandTypesEffect copy() {
        return new ChooseTwoBasicLandTypesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent mageObject = game.getPermanentEntering(source.getSourceId());
        if (mageObject == null) {
            mageObject = game.getObject(source);
        }
        if (controller != null && mageObject != null) {
            ChoiceBasicLandType choices = new ChoiceBasicLandType();
            if (controller.choose(Outcome.Neutral, (Choice)choices, game)) {
                game.informPlayers(mageObject.getName() + ":  First chosen basic land type is " + choices.getChoice());
                game.getState().setValue(mageObject.getId().toString() + "firstChoice", (Object)choices.getChoice());
                this.choiceOne = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "firstChoice"))).getDescription();
            }
            if (controller.choose(Outcome.Neutral, (Choice)choices, game)) {
                game.informPlayers(mageObject.getName() + ":  Second chosen basic land type is " + choices.getChoice());
                game.getState().setValue(mageObject.getId().toString() + "secondChoice", (Object)choices.getChoice());
                this.choiceTwo = SubType.byDescription((String)((String)game.getState().getValue(source.getSourceId().toString() + "secondChoice"))).getDescription();
                if (mageObject instanceof Permanent && this.choiceOne != null && this.choiceTwo != null) {
                    mageObject.addInfo("Chosen Types", CardUtil.addToolTipMarkTags((String)("First chosen basic land type: " + this.choiceOne + "\n Second chosen basic land type: " + this.choiceTwo)), game);
                }
                return true;
            }
        }
        return false;
    }
}

