/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.i.IanMalcolmChaoticianWatcher;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class IanMalcolmChaoticianExileEffect
extends OneShotEffect {
    IanMalcolmChaoticianExileEffect() {
        super(Outcome.Exile);
        this.staticText = "that player exiles the top card of their library";
    }

    private IanMalcolmChaoticianExileEffect(IanMalcolmChaoticianExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public IanMalcolmChaoticianExileEffect copy() {
        return new IanMalcolmChaoticianExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        UUID targetPlayerID = this.getTargetPointer().getFirst(game, source);
        Player targetPlayer = game.getPlayer(targetPlayerID);
        MageObject sourceObject = source.getSourceObject(game);
        if (targetPlayer == null || sourceObject == null) {
            return false;
        }
        Card card = targetPlayer.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)sourceObject.getId(), (int)sourceObject.getZoneChangeCounter(game));
        targetPlayer.moveCardsToExile(card, source, game, true, exileZoneId, sourceObject.getIdName());
        MageObjectReference sourceMOR = new MageObjectReference(source.getSourceId(), game);
        IanMalcolmChaoticianWatcher.addCard(sourceMOR, card, game);
        return true;
    }
}

