/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class IceCauldronNoteManaEffect
extends OneShotEffect {
    private String manaUsedString;

    public IceCauldronNoteManaEffect() {
        super(Outcome.Benefit);
        this.staticText = "and note the type and amount of mana spent to pay this activation cost";
    }

    private IceCauldronNoteManaEffect(IceCauldronNoteManaEffect effect) {
        super((OneShotEffect)effect);
        this.manaUsedString = effect.manaUsedString;
    }

    public IceCauldronNoteManaEffect copy() {
        return new IceCauldronNoteManaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent iceCauldron = game.getPermanent(source.getSourceId());
        if (controller != null && iceCauldron != null) {
            game.getState().setValue("IceCauldronMana" + source.getSourceId().toString(), (Object)source.getManaCostsToPay().getUsedManaToPay());
            this.manaUsedString = source.getManaCostsToPay().getUsedManaToPay().toString();
            iceCauldron.addInfo("MANA USED", CardUtil.addToolTipMarkTags((String)("Mana used last: " + this.manaUsedString)), game);
            return true;
        }
        return false;
    }
}

