/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class IchormoonGauntletEffect
extends OneShotEffect {
    IchormoonGauntletEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a counter on target permanent. Put an additional counter of that kind on that permanent";
    }

    private IchormoonGauntletEffect(IchormoonGauntletEffect effect) {
        super((OneShotEffect)effect);
    }

    public IchormoonGauntletEffect copy() {
        return new IchormoonGauntletEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        block5: {
            Permanent permanent;
            Player controller;
            block6: {
                controller = game.getPlayer(source.getControllerId());
                if (controller == null) {
                    return false;
                }
                permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
                if (permanent == null || permanent.getCounters(game).isEmpty()) {
                    return false;
                }
                if (permanent.getCounters(game).size() != 1) break block6;
                for (Counter counter : permanent.getCounters(game).values()) {
                    Counter newCounter = new Counter(counter.getName());
                    permanent.addCounters(newCounter, source.getControllerId(), source, game);
                }
                break block5;
            }
            ChoiceImpl choice = new ChoiceImpl(true);
            LinkedHashSet<String> choices = new LinkedHashSet<String>();
            for (Counter counter : permanent.getCounters(game).values()) {
                choices.add(counter.getName());
            }
            choice.setChoices(choices);
            choice.setMessage("Choose a counter");
            if (!controller.choose(Outcome.Benefit, (Choice)choice, game)) break block5;
            for (Counter counter : permanent.getCounters(game).values()) {
                if (!counter.getName().equals(choice.getChoice())) continue;
                Counter newCounter = new Counter(counter.getName());
                permanent.addCounters(newCounter, source.getControllerId(), source, game);
                break;
            }
        }
        return true;
    }
}

