/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class IdentityCrisisEffect
extends OneShotEffect {
    IdentityCrisisEffect() {
        super(Outcome.Exile);
        this.staticText = "Exile all cards from target player's hand and graveyard";
    }

    private IdentityCrisisEffect(IdentityCrisisEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getFirstTarget());
        Player player = game.getPlayer(source.getFirstTarget());
        if (controller == null || player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        cards.addAll((Collection)player.getHand());
        cards.addAll((Collection)player.getGraveyard());
        return controller.moveCards((Cards)cards, Zone.EXILED, source, game);
    }

    public IdentityCrisisEffect copy() {
        return new IdentityCrisisEffect(this);
    }
}

