/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.cards.i.IdolOfEnduranceDelayedTrigger;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class IdolOfEnduranceExileEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCreatureCard();

    IdolOfEnduranceExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile all creature cards with mana value 3 or less from your graveyard until {this} leaves the battlefield";
    }

    private IdolOfEnduranceExileEffect(IdolOfEnduranceExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public IdolOfEnduranceExileEffect copy() {
        return new IdolOfEnduranceExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (player == null || permanent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getGraveyard().getCards(filter, game));
        player.moveCardsToExile(cards.getCards(game), source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceName((Game)game, (Ability)source));
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new IdolOfEnduranceDelayedTrigger(), source);
        return true;
    }

    static {
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, 4));
    }
}

