/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.AnnihilatorAbility;
import mage.constants.CardType;
import mage.constants.DependencyType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class IdolOfFalseGodsEffect
extends ContinuousEffectImpl {
    IdolOfFalseGodsEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "as long as {this} has eight or more +1/+1 counters on it, it's a 0/0 creature in addition to its other types and it has annihilator 2";
        this.dependencyTypes.add(DependencyType.BecomeCreature);
    }

    private IdolOfFalseGodsEffect(IdolOfFalseGodsEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public IdolOfFalseGodsEffect copy() {
        return new IdolOfFalseGodsEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || permanent.getCounters(game).getCount(CounterType.P1P1) < 8) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.addCardType(game, new CardType[]{CardType.CREATURE});
                return true;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.addAbility((Ability)new AnnihilatorAbility(2), source.getSourceId(), game);
                return true;
            }
            case PTChangingEffects_7: {
                if (sublayer != SubLayer.SetPT_7b) break;
                permanent.getPower().setModifiedBaseValue(0);
                permanent.getToughness().setModifiedBaseValue(0);
                return true;
            }
        }
        return false;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case AbilityAddingRemovingEffects_6: 
            case PTChangingEffects_7: {
                return true;
            }
        }
        return false;
    }
}

