/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.AttacksAloneSourceTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.PermanentsOnBattlefieldCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.ValueHint;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class Idolized
extends CardImpl {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("nonland permanents you control");
    private static final DynamicValue xValue;
    private static final Hint hint;

    public Idolized(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{W}");
        this.subtype.add((Object)SubType.AURA);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.BoostCreature));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        Ability attacksAloneAbility = new AttacksAloneSourceTriggeredAbility((Effect)new BoostSourceEffect(xValue, xValue, Duration.EndOfTurn)).setTriggerPhrase("Whenever this creature attacks alone, ").addHint(hint);
        this.addAbility(new SimpleStaticAbility(Zone.BATTLEFIELD, (Effect)new GainAbilityAttachedEffect(attacksAloneAbility, AttachmentType.AURA)).addHint(hint));
    }

    private Idolized(Idolized card) {
        super((CardImpl)card);
    }

    public Idolized copy() {
        return new Idolized(this);
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
        xValue = new PermanentsOnBattlefieldCount((FilterPermanent)filter, null);
        hint = new ValueHint("Nonland permanents you control", xValue);
    }
}

