/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class IgniteTheFutureEffect
extends OneShotEffect {
    IgniteTheFutureEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile the top three cards of your library. Until the end of your next turn, you may play those cards. If this spell was cast from a graveyard, you may play cards this way without paying their mana costs.";
    }

    private IgniteTheFutureEffect(IgniteTheFutureEffect effect) {
        super((OneShotEffect)effect);
    }

    public IgniteTheFutureEffect copy() {
        return new IgniteTheFutureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Spell spell = (Spell)game.getStack().getStackObject(source.getSourceId());
        if (controller == null || spell == null) {
            return false;
        }
        Set cards = controller.getLibrary().getTopCards(game, 3);
        return PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Set)cards, (TargetController)TargetController.YOU, (Duration)Duration.UntilEndOfYourNextTurn, (boolean)Zone.GRAVEYARD.equals((Object)spell.getFromZone()), (boolean)false, (boolean)false);
    }
}

