/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetDiscard;

class IllTimedExplosionEffect
extends OneShotEffect {
    IllTimedExplosionEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you may discard two cards. When you do, {this} deals X damage to each creature, where X is the greatest mana value among cards discarded this way";
    }

    private IllTimedExplosionEffect(IllTimedExplosionEffect effect) {
        super((OneShotEffect)effect);
    }

    public IllTimedExplosionEffect copy() {
        return new IllTimedExplosionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().size() < 2 || !player.chooseUse(this.outcome, "Discard two cards?", source, game)) {
            return false;
        }
        TargetDiscard target = new TargetDiscard(2, StaticFilters.FILTER_CARD_CARDS, source.getControllerId());
        player.choose(this.outcome, (Target)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        player.discard((Cards)cards, false, source, game);
        int xValue = cards.getCards(game).stream().mapToInt(MageObject::getManaValue).max().orElse(0);
        game.fireReflexiveTriggeredAbility(new ReflexiveTriggeredAbility((Effect)new DamageAllEffect(xValue, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE), false), source);
        return true;
    }
}

