/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Objects;
import mage.abilities.Ability;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.cards.i.CreatureEvaluator;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.players.PlayerList;

class IllicitAuctionEffect
extends GainControlTargetEffect {
    IllicitAuctionEffect() {
        super(Duration.EndOfGame);
        this.staticText = "Each player may bid life for control of target creature. You start the bidding with a bid of 0. In turn order, each player may top the high bid. The bidding ends if the high bid stands. The high bidder loses life equal to the high bid and gains control of the creature.";
    }

    private IllicitAuctionEffect(IllicitAuctionEffect effect) {
        super((GainControlTargetEffect)effect);
    }

    public IllicitAuctionEffect copy() {
        return new IllicitAuctionEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        Player controller = game.getPlayer(source.getControllerId());
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (controller != null && targetCreature != null) {
            PlayerList playerList = game.getState().getPlayersInRange(controller.getId(), game);
            Player winner = game.getPlayer(controller.getId());
            int highBid = 0;
            game.informPlayers(winner.getLogName() + " has bet 0 lifes");
            Player currentPlayer = playerList.getNext(game, false);
            while (currentPlayer != null && !Objects.equals(currentPlayer, winner)) {
                String text = winner.getLogName() + " has bet " + highBid + " life" + (highBid > 1 ? "s" : "") + ". Top the bid?";
                if (currentPlayer.canRespond() && currentPlayer.chooseUse(Outcome.GainControl, text, source, game)) {
                    int newBid = 0;
                    if (currentPlayer.isComputer()) {
                        CreatureEvaluator eval = new CreatureEvaluator();
                        int computerLife = currentPlayer.getLife();
                        int creatureValue = eval.evaluate(targetCreature, game);
                        newBid = Math.max(creatureValue % 2, computerLife - 100);
                    } else if (currentPlayer.canRespond()) {
                        newBid = currentPlayer.getAmount(highBid + 1, Integer.MAX_VALUE, "Choose bid", source, game);
                    }
                    if (newBid > highBid) {
                        highBid = newBid;
                        winner = currentPlayer;
                        game.informPlayers(currentPlayer.getLogName() + " bet " + newBid + " life" + (newBid > 1 ? "s" : ""));
                    }
                }
                currentPlayer = playerList.getNext(game, false);
                if (!game.getState().getPlayersInRange(controller.getId(), game).isEmpty()) continue;
                break;
            }
            game.informPlayers(winner.getLogName() + " won the auction with a bid of " + highBid + " life" + (highBid > 1 ? "s" : ""));
            winner.loseLife(highBid, game, source, false);
            this.controllingPlayerId = winner.getId();
        }
    }
}

