/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Arrays;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureAllEffect;
import mage.abilities.effects.common.continuous.BecomesSubtypeAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.target.Target;

class IllithidHarvesterEffect
extends OneShotEffect {
    IllithidHarvesterEffect() {
        super(Outcome.Detriment);
        this.staticText = "turn any number of target tapped nontoken creatures face down. They're 2/2 Horror creatures";
    }

    private IllithidHarvesterEffect(IllithidHarvesterEffect effect) {
        super((OneShotEffect)effect);
    }

    public IllithidHarvesterEffect copy() {
        return new IllithidHarvesterEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        PermanentIdPredicate pred = new PermanentIdPredicate(UUID.randomUUID());
        for (Target target : source.getTargets()) {
            for (UUID targetId : target.getTargets()) {
                if (game.getPermanent(targetId).isTransformable()) continue;
                pred = Predicates.or((Predicate)pred, (Predicate)new PermanentIdPredicate(targetId));
            }
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)pred);
        game.addEffect((ContinuousEffect)new BecomesFaceDownCreatureAllEffect((FilterPermanent)filter), source);
        game.addEffect((ContinuousEffect)new BecomesSubtypeAllEffect(Duration.WhileOnBattlefield, Arrays.asList(SubType.HORROR), filter, false), source);
        return true;
    }
}

