/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorlessPredicate;
import mage.game.Game;
import mage.target.common.TargetCardInHand;

class IlluminatedFolioTarget
extends TargetCardInHand {
    private static final FilterCard filter = new FilterCard("cards from your hand that share a color");

    public IlluminatedFolioTarget() {
        super(2, filter);
    }

    private IlluminatedFolioTarget(IlluminatedFolioTarget target) {
        super((TargetCardInHand)target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (!super.canTarget(playerId, id, source, game)) {
            return false;
        }
        List targetList = this.getTargets();
        if (targetList.isEmpty()) {
            return true;
        }
        Card card = game.getCard(id);
        if (card == null) return false;
        if (!targetList.stream().map(arg_0 -> ((Game)game).getCard(arg_0)).filter(Objects::nonNull).anyMatch(c -> c.getColor(game).shares(card.getColor(game)))) return false;
        return true;
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set possibleTargets = super.possibleTargets(sourceControllerId, source, game);
        possibleTargets.removeIf(uuid -> !this.canTarget(sourceControllerId, (UUID)uuid, source, game));
        return possibleTargets;
    }

    public IlluminatedFolioTarget copy() {
        return new IlluminatedFolioTarget(this);
    }

    static {
        filter.add(Predicates.not((Predicate)ColorlessPredicate.instance));
    }
}

