/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RequirementEffect;
import mage.constants.Duration;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.turn.Phase;

class IllusionistsGambitRequirementEffect
extends RequirementEffect {
    private Set<UUID> attackers;
    private Phase phase;

    public IllusionistsGambitRequirementEffect(Set<UUID> attackers, Phase phase) {
        super(Duration.Custom);
        this.attackers = attackers;
        this.phase = phase;
        this.staticText = "Each of those creatures attacks that combat if able";
    }

    private IllusionistsGambitRequirementEffect(IllusionistsGambitRequirementEffect effect) {
        super((RequirementEffect)effect);
        this.attackers = effect.attackers;
        this.phase = effect.phase;
    }

    public IllusionistsGambitRequirementEffect copy() {
        return new IllusionistsGambitRequirementEffect(this);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (this.attackers.contains(permanent.getId())) {
            return game.getOpponents(permanent.getControllerId()).size() > 1;
        }
        return false;
    }

    public boolean isInactive(Ability source, Game game) {
        if (game.getTurnStepType() == PhaseStep.END_COMBAT) {
            return !Objects.equals(game.getTurn().getPhase(), this.phase);
        }
        return false;
    }

    public boolean mustAttack(Game game) {
        return true;
    }

    public boolean mustBlock(Game game) {
        return false;
    }
}

