/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;

class ImagesOfThePastEffect
extends OneShotEffect {
    ImagesOfThePastEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return up to two target creature cards from your graveyard to the battlefield, then exile those creatures";
    }

    private ImagesOfThePastEffect(ImagesOfThePastEffect effect) {
        super((OneShotEffect)effect);
    }

    public ImagesOfThePastEffect copy() {
        return new ImagesOfThePastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            List targets = ((Target)source.getTargets().get(0)).getTargets();
            for (UUID targetId : targets) {
                Card card = game.getCard(targetId);
                if (card == null) continue;
                player.moveCards(card, Zone.BATTLEFIELD, source, game);
                player.moveCards(card, Zone.EXILED, source, game);
            }
            return true;
        }
        return false;
    }
}

