/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ImmaculateMagistrateEffect
extends OneShotEffect {
    static final FilterControlledPermanent filter = new FilterControlledPermanent("Elf");

    public ImmaculateMagistrateEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "Put a +1/+1 counter on target creature for each Elf you control";
    }

    private ImmaculateMagistrateEffect(ImmaculateMagistrateEffect effect) {
        super((OneShotEffect)effect);
    }

    public ImmaculateMagistrateEffect copy() {
        return new ImmaculateMagistrateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int count;
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent != null && (count = game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game)) > 0) {
            permanent.addCounters(CounterType.P1P1.createInstance(count), source.getControllerId(), source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.ELF.getPredicate());
    }
}

