/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ImminentDoomEffect
extends OneShotEffect {
    ImminentDoomEffect() {
        super(Outcome.Detriment);
    }

    private ImminentDoomEffect(ImminentDoomEffect effect) {
        super((OneShotEffect)effect);
    }

    public ImminentDoomEffect copy() {
        return new ImminentDoomEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent imminentDoom = game.getPermanent(source.getSourceId());
        if (imminentDoom != null) {
            DamageTargetEffect effect = new DamageTargetEffect(((Integer)game.getState().getValue("ImminentDoomCount" + source.getSourceId().toString())).intValue());
            effect.apply(game, source);
            imminentDoom.addCounters(CounterType.DOOM.createInstance(), source.getControllerId(), source, game);
            return true;
        }
        return false;
    }
}

