/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.i.ImminentDoomEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class ImminentDoomTriggeredAbility
extends TriggeredAbilityImpl {
    private String rule = "Whenever you cast a spell with mana value equal to the number of doom counters on {this}, {this} deals that much damage to any target. Then put a doom counter on {this}.";

    public ImminentDoomTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new ImminentDoomEffect());
    }

    private ImminentDoomTriggeredAbility(ImminentDoomTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ImminentDoomTriggeredAbility copy() {
        return new ImminentDoomTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (event.getPlayerId().equals(this.getControllerId())) {
            Permanent imminentDoom = game.getPermanent(this.getSourceId());
            Spell spell = game.getStack().getSpell(event.getTargetId());
            if (spell != null && imminentDoom != null && spell.getManaValue() == imminentDoom.getCounters(game).getCount(CounterType.DOOM)) {
                game.getState().setValue("ImminentDoomCount" + this.getSourceId().toString(), (Object)imminentDoom.getCounters(game).getCount(CounterType.DOOM));
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return this.rule;
    }
}

