/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.StackAbility;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ImmolationShamanTriggeredAbility
extends TriggeredAbilityImpl {
    ImmolationShamanTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect((DynamicValue)StaticValue.get((int)1), true, "that player", true));
        this.setTriggerPhrase("Whenever an opponent activates an ability of an artifact, creature, or land that isn't a mana ability, ");
    }

    private ImmolationShamanTriggeredAbility(ImmolationShamanTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ImmolationShamanTriggeredAbility copy() {
        return new ImmolationShamanTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ACTIVATED_ABILITY;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        StackAbility stackAbility;
        Permanent source;
        if (!event.getPlayerId().equals(this.getControllerId()) && (source = game.getPermanentOrLKIBattlefield(event.getSourceId())) != null && (source.isArtifact(game) || source.isCreature(game) || source.isLand(game)) && !(stackAbility = (StackAbility)game.getStack().getStackObject(event.getSourceId())).getStackAbility().isManaActivatedAbility()) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getPlayerId()));
            }
            return true;
        }
        return false;
    }
}

