/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class ImmortalCoilPreventionEffect
extends PreventionEffectImpl {
    ImmortalCoilPreventionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "If damage would be dealt to you, prevent that damage. Exile a card from your graveyard for each 1 damage prevented this way";
    }

    private ImmortalCoilPreventionEffect(ImmortalCoilPreventionEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public ImmortalCoilPreventionEffect copy() {
        return new ImmortalCoilPreventionEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        if (game.replaceEvent((GameEvent)new PreventDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), event.getAmount(), ((DamageEvent)event).isCombatDamage()))) {
            return false;
        }
        int damage = event.getAmount();
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(Math.min(damage, player.getGraveyard().size()), StaticFilters.FILTER_CARD);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.EXILED, source, game);
        }
        event.setAmount(0);
        game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), damage));
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return super.applies(event, source, game) && event.getTargetId().equals(source.getControllerId());
    }
}

