/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Objects;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ImmortalServitudeEffect
extends OneShotEffect {
    ImmortalServitudeEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return each creature card with mana value X from your graveyard to the battlefield";
    }

    private ImmortalServitudeEffect(ImmortalServitudeEffect effect) {
        super((OneShotEffect)effect);
    }

    public ImmortalServitudeEffect copy() {
        return new ImmortalServitudeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        if (you == null) {
            return false;
        }
        int count = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        Set cards = you.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game);
        cards.removeIf(Objects::isNull);
        cards.removeIf(card -> !card.isCreature(game));
        cards.removeIf(card -> card.getManaValue() != count);
        return you.moveCards(cards, Zone.BATTLEFIELD, source, game);
    }
}

