/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ImmovableRodAttackBlockTargetEffect
extends RestrictionEffect {
    ImmovableRodAttackBlockTargetEffect() {
        super(Duration.Custom);
        this.staticText = "and can't attack or block";
    }

    private ImmovableRodAttackBlockTargetEffect(ImmovableRodAttackBlockTargetEffect effect) {
        super((RestrictionEffect)effect);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (sourcePermanent == null || !sourcePermanent.isTapped()) {
            this.discard();
            return false;
        }
        return permanent.getId().equals(this.getTargetPointer().getFirst(game, source));
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean canBlock(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public ImmovableRodAttackBlockTargetEffect copy() {
        return new ImmovableRodAttackBlockTargetEffect(this);
    }
}

