/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeTargetEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ImperialHovertankTriggeredAbility
extends TriggeredAbilityImpl {
    public ImperialHovertankTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new LoseLifeTargetEffect(1));
        this.addEffect((Effect)new GainLifeEffect(1));
    }

    private ImperialHovertankTriggeredAbility(ImperialHovertankTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public ImperialHovertankTriggeredAbility copy() {
        return new ImperialHovertankTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent source = game.getPermanent(event.getSourceId());
        if (source != null && source.isControlledBy(this.controllerId) && source.hasSubtype(SubType.TROOPER, game)) {
            UUID defendingPlayerId = game.getCombat().getDefendingPlayerId(event.getSourceId(), game);
            ((Effect)this.getEffects().get(0)).setTargetPointer((TargetPointer)new FixedTarget(defendingPlayerId));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a Trooper creature you control attacks, defending player loses 1 life and you gain 1 life.";
    }
}

