/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.HashMap;
import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CommanderCardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class ImposingGrandeurEffect
extends OneShotEffect {
    ImposingGrandeurEffect() {
        super(Outcome.DrawCard);
        this.staticText = "each player may discard their hand and draw cards equal to the greatest mana value of a commander they own on the battlefield or in the command zone";
    }

    private ImposingGrandeurEffect(ImposingGrandeurEffect effect) {
        super((OneShotEffect)effect);
    }

    public ImposingGrandeurEffect copy() {
        return new ImposingGrandeurEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        HashMap<UUID, Integer> map = new HashMap<UUID, Integer>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            int maxValue = game.getCommanderCardsFromAnyZones(player, CommanderCardType.ANY, new Zone[]{Zone.BATTLEFIELD, Zone.COMMAND}).stream().mapToInt(MageObject::getManaValue).max().orElse(0);
            map.put(playerId, maxValue);
        }
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            player = game.getPlayer(playerId);
            int amount = map.getOrDefault(playerId, 0);
            if (player == null || !player.chooseUse(this.outcome, "Discard your hand and draw " + amount + " cards?", source, game)) continue;
            player.discard(player.getHand(), false, source, game);
            player.drawCards(amount, source, game);
        }
        return true;
    }
}

