/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.mana.ColorlessManaAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class ImprisonedInTheMoonEffect
extends ContinuousEffectImpl {
    ImprisonedInTheMoonEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Enchanted permanent is a colorless land with \"{T}: Add {C}\" and loses all other card types and abilities";
    }

    private ImprisonedInTheMoonEffect(ImprisonedInTheMoonEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public ImprisonedInTheMoonEffect copy() {
        return new ImprisonedInTheMoonEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        Permanent enchantment = source.getSourcePermanentIfItStillExists(game);
        if (enchantment == null || enchantment.getAttachedTo() == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(enchantment.getAttachedTo());
        if (permanent == null) {
            return false;
        }
        switch (layer) {
            case TypeChangingEffects_4: {
                permanent.removeAllAbilities(source.getSourceId(), game);
                permanent.removeAllCardTypes(game);
                permanent.addCardType(game, new CardType[]{CardType.LAND});
                permanent.retainAllLandSubTypes(game);
                break;
            }
            case ColorChangingEffects_5: {
                permanent.getColor(game).setWhite(false);
                permanent.getColor(game).setBlue(false);
                permanent.getColor(game).setBlack(false);
                permanent.getColor(game).setRed(false);
                permanent.getColor(game).setGreen(false);
                break;
            }
            case AbilityAddingRemovingEffects_6: {
                permanent.removeAllAbilities(source.getSourceId(), game);
                permanent.addAbility((Ability)new ColorlessManaAbility(), source.getSourceId(), game);
            }
        }
        return true;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.AbilityAddingRemovingEffects_6 || layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4;
    }
}

