/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class InameDeathAspectEffect
extends SearchEffect {
    private static final FilterCard filter = new FilterCard();

    public InameDeathAspectEffect() {
        super(new TargetCardInLibrary(0, Integer.MAX_VALUE, filter), Outcome.Neutral);
        this.staticText = "search your library for any number of Spirit cards, put them into your graveyard, then shuffle";
    }

    private InameDeathAspectEffect(InameDeathAspectEffect effect) {
        super((SearchEffect)effect);
    }

    public InameDeathAspectEffect copy() {
        return new InameDeathAspectEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null && player.searchLibrary(this.target, source, game)) {
            if (!this.target.getTargets().isEmpty()) {
                player.moveCards((Cards)new CardsImpl((Collection)this.target.getTargets()), Zone.GRAVEYARD, source, game);
            }
            player.shuffleLibrary(source, game);
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.SPIRIT.getPredicate());
    }
}

