/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class IncriminateEffect
extends OneShotEffect {
    IncriminateEffect() {
        super(Outcome.Detriment);
        this.staticText = "choose two target creatures controlled by the same player. That player sacrifices one of them";
    }

    private IncriminateEffect(IncriminateEffect effect) {
        super((OneShotEffect)effect);
    }

    public IncriminateEffect copy() {
        return new IncriminateEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = null;
        FilterPermanent filter = new FilterPermanent("creature to sacrifice");
        ArrayList<PermanentIdPredicate> permanentIdPredicates = new ArrayList<PermanentIdPredicate>();
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            permanentIdPredicates.add(new PermanentIdPredicate(game.getPermanent(targetId).getId()));
            player = game.getPlayer(game.getPermanent(targetId).getControllerId());
        }
        if (permanentIdPredicates.isEmpty() || player == null) {
            return false;
        }
        filter.add(Predicates.or(permanentIdPredicates));
        TargetSacrifice target = new TargetSacrifice(filter);
        player.choose(Outcome.Sacrifice, (Target)target, source, game);
        Permanent sacrificeCreature = game.getPermanent(target.getFirstTarget());
        return sacrificeCreature != null && sacrificeCreature.sacrifice(source, game);
    }
}

