/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class IndenturedDjinnEffect
extends OneShotEffect {
    IndenturedDjinnEffect() {
        super(Outcome.DrawCard);
        this.staticText = "each other player may draw up to three cards";
    }

    private IndenturedDjinnEffect(IndenturedDjinnEffect effect) {
        super((OneShotEffect)effect);
    }

    public IndenturedDjinnEffect copy() {
        return new IndenturedDjinnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getOpponents(source.getControllerId())) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                DrawCardTargetEffect effect = new DrawCardTargetEffect((DynamicValue)StaticValue.get((int)3), false, true);
                effect.setTargetPointer((TargetPointer)new FixedTarget(playerId));
                effect.setText(player.getLogName() + " may draw up to three cards");
                effect.apply(game, source);
            }
            return true;
        }
        return false;
    }
}

