/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.keyword.DeathtouchAbility;
import mage.abilities.keyword.DoubleStrikeAbility;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.abilities.keyword.FlyingAbility;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.HexproofAbility;
import mage.abilities.keyword.HexproofBaseAbility;
import mage.abilities.keyword.IndestructibleAbility;
import mage.abilities.keyword.LifelinkAbility;
import mage.abilities.keyword.MenaceAbility;
import mage.abilities.keyword.ReachAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.counters.AbilityCounter;
import mage.counters.Counter;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetDiscard;

class IndominusRexAlphaCountersEffect
extends OneShotEffect {
    private static final List<Ability> copyableAbilities = Arrays.asList(FlyingAbility.getInstance(), FirstStrikeAbility.getInstance(), DoubleStrikeAbility.getInstance(), DeathtouchAbility.getInstance(), HexproofAbility.getInstance(), HasteAbility.getInstance(), IndestructibleAbility.getInstance(), LifelinkAbility.getInstance(), new MenaceAbility(), ReachAbility.getInstance(), TrampleAbility.getInstance(), VigilanceAbility.getInstance());

    IndominusRexAlphaCountersEffect() {
        super(Outcome.AIDontUseIt);
        this.staticText = "discard any number of creature cards. It enters with a flying counter on it if a card discarded this way has flying. The same is true for first strike, double strike, deathtouch, hexproof, haste, indestructible, lifelink, menace, reach, trample, and vigilance.";
    }

    private IndominusRexAlphaCountersEffect(IndominusRexAlphaCountersEffect effect) {
        super((OneShotEffect)effect);
    }

    public IndominusRexAlphaCountersEffect copy() {
        return new IndominusRexAlphaCountersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (permanent == null) {
            return true;
        }
        TargetDiscard target = new TargetDiscard(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_CREATURE, controller.getId());
        controller.choose(this.outcome, controller.getHand(), (TargetCard)target, source, game);
        List chosenTargets = target.getTargets();
        controller.discard((Cards)new CardsImpl((Collection)target.getTargets()), false, source, game);
        game.processAction();
        ArrayList appliedEffects = (ArrayList)this.getValue("appliedEffects");
        ArrayList<Ability> abilitiesToAdd = new ArrayList<Ability>();
        for (Ability abilityToCopy : copyableAbilities) {
            for (UUID targetId : chosenTargets) {
                Card card = game.getCard(targetId);
                if (card == null) continue;
                for (Ability ability : card.getAbilities(game)) {
                    if (abilitiesToAdd.stream().anyMatch(a -> a.getClass().isInstance(ability))) continue;
                    if (abilityToCopy.getClass().isInstance(ability)) {
                        abilitiesToAdd.add(ability);
                        continue;
                    }
                    if (!(ability instanceof HexproofBaseAbility)) continue;
                    abilitiesToAdd.add(ability);
                }
            }
        }
        for (Ability abilityToCopy : abilitiesToAdd) {
            permanent.addCounters((Counter)new AbilityCounter(abilityToCopy, 1), source.getControllerId(), source, game, (List)appliedEffects);
        }
        return !abilitiesToAdd.isEmpty();
    }
}

