/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Library;
import mage.players.Player;

class IndomitableCreativityEffect
extends OneShotEffect {
    IndomitableCreativityEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy X target artifacts and/or creatures. For each permanent destroyed this way, its controller reveals cards from the top of their library until an artifact or creature card is revealed and exiles that card. Those players put the exiled cards onto the battlefield, then shuffle";
    }

    private IndomitableCreativityEffect(IndomitableCreativityEffect effect) {
        super((OneShotEffect)effect);
    }

    public IndomitableCreativityEffect copy() {
        return new IndomitableCreativityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        ArrayList<Permanent> destroyedPermanents = new ArrayList<Permanent>();
        for (UUID targetId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null || !permanent.destroy(source, game, false)) continue;
            destroyedPermanents.add(permanent);
        }
        if (destroyedPermanents.isEmpty()) {
            return false;
        }
        game.processAction();
        HashMap<UUID, Set> playerToBattlefield = new HashMap<UUID, Set>();
        for (Permanent permanent : destroyedPermanents) {
            Library library;
            Player controllerOfDestroyedCreature = game.getPlayer(permanent.getControllerId());
            if (controllerOfDestroyedCreature == null || !(library = controllerOfDestroyedCreature.getLibrary()).hasCards()) continue;
            playerToBattlefield.computeIfAbsent(controllerOfDestroyedCreature.getId(), x -> new HashSet());
            CardsImpl cardsToReveal = new CardsImpl();
            for (Card card : library.getCards(game)) {
                cardsToReveal.add(card);
                if (!card.isCreature(game) && !card.isArtifact(game)) continue;
                controllerOfDestroyedCreature.moveCards(card, Zone.EXILED, source, game);
                playerToBattlefield.computeIfAbsent(controllerOfDestroyedCreature.getId(), x -> new HashSet()).add(card);
                break;
            }
            controllerOfDestroyedCreature.revealCards(source, " for destroyed " + permanent.getIdName(), (Cards)cardsToReveal, game);
        }
        game.processAction();
        for (Map.Entry entry : playerToBattlefield.entrySet()) {
            Player player = game.getPlayer((UUID)entry.getKey());
            if (player == null) continue;
            player.moveCards((Set)entry.getValue(), Zone.BATTLEFIELD, source, game);
            player.shuffleLibrary(source, game);
        }
        return true;
    }
}

