/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.AsThoughEffectImpl;
import mage.constants.AsThoughEffectType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class IndomitableMightEffect
extends AsThoughEffectImpl {
    IndomitableMightEffect() {
        super(AsThoughEffectType.DAMAGE_NOT_BLOCKED, Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "enchanted creature's controller may have it assign its combat damage as though it weren't blocked";
    }

    private IndomitableMightEffect(IndomitableMightEffect effect) {
        super((AsThoughEffectImpl)effect);
    }

    public boolean applies(UUID sourceId, Ability source, UUID affectedControllerId, Game game) {
        Permanent sourcePermanent = source.getSourcePermanentOrLKI(game);
        if (sourcePermanent == null) {
            return false;
        }
        Permanent permanent = game.getPermanent(sourcePermanent.getAttachedTo());
        if (permanent == null || !sourceId.equals(permanent.getId())) {
            return false;
        }
        Player controller = game.getPlayer(permanent.getControllerId());
        return controller != null && controller.chooseUse(Outcome.Damage, "Have " + permanent.getLogName() + " assign damage as though it weren't blocked?", source, game);
    }

    public boolean apply(Game game, Ability source) {
        return true;
    }

    public IndomitableMightEffect copy() {
        return new IndomitableMightEffect(this);
    }
}

