/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.costs.common.RevealTargetFromHandCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class InduceDespairEffect
extends OneShotEffect {
    InduceDespairEffect() {
        super(Outcome.UnboostCreature);
        this.staticText = "Target creature gets -X/-X until end of turn, where X is the revealed card's mana value";
    }

    private InduceDespairEffect(InduceDespairEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        RevealTargetFromHandCost cost = (RevealTargetFromHandCost)source.getCosts().get(0);
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (cost != null && creature != null) {
            int cmcBoost = -1 * cost.manaValues;
            BoostTargetEffect effect = new BoostTargetEffect(cmcBoost, cmcBoost, Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(creature.getId(), creature.getZoneChangeCounter(game)));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }

    public InduceDespairEffect copy() {
        return new InduceDespairEffect(this);
    }
}

