/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.common.TargetOpponent;

class InfernalOfferingReturnEffect
extends OneShotEffect {
    InfernalOfferingReturnEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Choose an opponent. Return a creature card from your graveyard to the battlefield, then that player returns a creature card from their graveyard to the battlefield";
    }

    private InfernalOfferingReturnEffect(InfernalOfferingReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public InfernalOfferingReturnEffect copy() {
        return new InfernalOfferingReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card;
            TargetOpponent target = new TargetOpponent(true);
            target.choose(Outcome.PutCreatureInPlay, source.getControllerId(), source.getSourceId(), source, game);
            Player opponent = game.getPlayer(target.getFirstTarget());
            target = new TargetCardInYourGraveyard((FilterCard)new FilterCreatureCard("creature card in your graveyard"));
            if (target.choose(Outcome.PutCreatureInPlay, controller.getId(), source.getSourceId(), source, game) && (card = controller.getGraveyard().get(target.getFirstTarget(), game)) != null) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            if (opponent != null && (target = new TargetCardInYourGraveyard((FilterCard)new FilterCreatureCard("creature card in your graveyard"))).choose(Outcome.PutCreatureInPlay, opponent.getId(), source.getSourceId(), source, game) && (card = opponent.getGraveyard().get(target.getFirstTarget(), game)) != null) {
                opponent.moveCards(card, Zone.BATTLEFIELD, source, game);
            }
            return true;
        }
        return false;
    }
}

