/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class InfernoOfTheStarMountsEffect
extends OneShotEffect {
    InfernoOfTheStarMountsEffect() {
        super(Outcome.Damage);
        this.staticText = "When its power becomes 20 this way, it deals 20 damage to any target";
    }

    private InfernoOfTheStarMountsEffect(InfernoOfTheStarMountsEffect effect) {
        super((OneShotEffect)effect);
    }

    public InfernoOfTheStarMountsEffect copy() {
        return new InfernoOfTheStarMountsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent != null && permanent.getPower().getValue() == 20) {
            ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(20), false, this.staticText);
            ability.addTarget((Target)new TargetAnyTarget());
            game.fireReflexiveTriggeredAbility(ability, source);
            return true;
        }
        return false;
    }
}

