/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.costs.AlternativeCostSourceAbility;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;
import mage.util.CardUtil;

class IngeniousMasteryEffect
extends OneShotEffect {
    private final UUID alternativeCostOriginalID;

    IngeniousMasteryEffect(UUID alternativeCostOriginalID) {
        super(Outcome.Detriment);
        this.staticText = "if the {2}{U} cost was paid, you draw three cards, then an opponent creates two Treasure tokens and they scry 2. If that cost wasn't paid, you draw X cards";
        this.alternativeCostOriginalID = alternativeCostOriginalID;
    }

    private IngeniousMasteryEffect(IngeniousMasteryEffect effect) {
        super((OneShotEffect)effect);
        this.alternativeCostOriginalID = effect.alternativeCostOriginalID;
    }

    public IngeniousMasteryEffect copy() {
        return new IngeniousMasteryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (!AlternativeCostSourceAbility.getActivatedStatus((Game)game, (Ability)source, (UUID)this.alternativeCostOriginalID, (boolean)false)) {
            return player.drawCards(((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue(), source, game) > 0;
        }
        player.drawCards(3, source, game);
        TargetOpponent targetOpponent = new TargetOpponent(true);
        if (!player.chooseTarget(Outcome.DrawCard, (Target)targetOpponent, source, game)) {
            return false;
        }
        Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
        if (opponent == null) {
            return false;
        }
        new TreasureToken().putOntoBattlefield(2, game, source, opponent.getId());
        opponent.scry(2, source, game);
        return true;
    }
}

