/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class InhumaniacEffect
extends OneShotEffect {
    InhumaniacEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a six-sided die. On a 3 or 4, put a +1/+1 counter on {this}. On a 5 or higher, put two +1/+1 counters on it. On a 1, remove all +1/+1 counters from {this}";
    }

    private InhumaniacEffect(InhumaniacEffect effect) {
        super((OneShotEffect)effect);
    }

    public InhumaniacEffect copy() {
        return new InhumaniacEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null) {
            int numToRemove;
            int amount = controller.rollDice(this.outcome, source, game, 6);
            if (amount >= 3 && amount <= 4) {
                permanent.addCounters(CounterType.P1P1.createInstance(1), source.getControllerId(), source, game);
            } else if (amount >= 5) {
                permanent.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game);
            } else if (amount == 1 && (numToRemove = permanent.getCounters(game).getCount(CounterType.P1P1)) > 0) {
                permanent.removeCounters(CounterType.P1P1.getName(), numToRemove, source, game);
            }
            return true;
        }
        return false;
    }
}

