/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class InnerStruggleEffect
extends OneShotEffect {
    InnerStruggleEffect() {
        super(Outcome.Damage);
        this.staticText = "Target creature deals damage to itself equal to its power";
    }

    private InnerStruggleEffect(InnerStruggleEffect effect) {
        super((OneShotEffect)effect);
    }

    public InnerStruggleEffect copy() {
        return new InnerStruggleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetCreature != null) {
                targetCreature.damage(targetCreature.getPower().getValue(), targetCreature.getId(), source, game, false, true);
            }
            return true;
        }
        return false;
    }
}

