/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.i;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.players.PlayerList;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class InniazTheGaleForceEffect
extends OneShotEffect {
    InniazTheGaleForceEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player gains control of a nonland permanent of your choice controlled by the player to their right.";
    }

    private InniazTheGaleForceEffect(InniazTheGaleForceEffect effect) {
        super((OneShotEffect)effect);
    }

    public InniazTheGaleForceEffect copy() {
        return new InniazTheGaleForceEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        PlayerList playerList = game.getState().getPlayersInRange(source.getControllerId(), game);
        ArrayList<PlayerPair> playerPairList = new ArrayList<PlayerPair>();
        for (int i = 0; i < playerList.size() - 1; ++i) {
            playerPairList.add(new PlayerPair(game.getPlayer((UUID)playerList.get(i)), game.getPlayer((UUID)playerList.get(i + 1))));
        }
        playerPairList.add(new PlayerPair(game.getPlayer((UUID)playerList.get(playerList.size() - 1)), game.getPlayer((UUID)playerList.get(0))));
        for (PlayerPair playerPair : playerPairList) {
            playerPair.chooseTargets(controller, game, source);
        }
        for (PlayerPair playerPair : playerPairList) {
            playerPair.createEffect(game, source);
        }
        return true;
    }

    private static final class PlayerPair {
        private final Player leftPlayer;
        private final Player rightPlayer;
        private final FilterPermanent filter;
        private final TargetPermanent target;

        private PlayerPair(Player rightPlayer, Player leftPlayer) {
            this.leftPlayer = leftPlayer;
            this.rightPlayer = rightPlayer;
            this.filter = this.makeFilter();
            this.target = this.makeTarget();
        }

        private FilterPermanent makeFilter() {
            FilterNonlandPermanent filter = new FilterNonlandPermanent("nonland permanent controlled by " + this.rightPlayer.getName() + " to give to " + this.leftPlayer.getName());
            filter.add((Predicate)new ControllerIdPredicate(this.rightPlayer.getId()));
            return filter;
        }

        private TargetPermanent makeTarget() {
            return new TargetPermanent(1, 1, this.filter, true);
        }

        private void chooseTargets(Player controller, Game game, Ability source) {
            if (game.getBattlefield().count(this.filter, source.getControllerId(), source, game) > 0) {
                controller.choose(Outcome.Neutral, (Target)this.target, source, game);
            }
        }

        private void createEffect(Game game, Ability source) {
            if (this.target.getFirstTarget() == null) {
                return;
            }
            game.addEffect(new GainControlTargetEffect(Duration.Custom, true, this.leftPlayer.getId()).setTargetPointer((TargetPointer)new FixedTarget(this.target.getFirstTarget(), game)), source);
        }
    }
}

